/* "@(#)$Id: err1432.h,v 1.136 1999/02/24 21:01:31 dhiller Exp $" */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* This header file declares the error and warning values that may be
   returned by the lib1432.a or lib1432.sl library.  Any host program
   that makes use of specific error or warning values from the E1432
   module should include this file. */

#ifndef	_E1432_ERROR_H
#define	_E1432_ERROR_H

/* measurement warnings */
#define WARN1432_NO_WARNING				0
#define WARN1432_LOST_NOT_ENOUGH_TACHS           	1
#define WARN1432_LOST_TOO_MANY_TACHS 	          	2
#define WARN1432_LOST_TOO_MANY_POINTS_REQUIRED   	3
#define WARN1432_LOST_DATA_SHIFTED_OUT_FIFO      	4
#define WARN1432_LOST_NOT_ENOUGH_DATA_FIFO       	5
#define WARN1432_LOST_RPM_TOO_HIGH               	6
#define WARN1432_LOST_RPM_TOO_LOW                	7
#define WARN1432_LOST_RESAMPLE_ERROR             	8
#define WARN1432_LOST_FIFO_EMPTIED			9
#define WARN1432_RPM_RAMP_TOO_FAST			10

#define WARN1432_LAST_WARNING_NUMBER			10


#define ERR1432_ERROR_OFFSET			-1300

/* analog */
#define ERR1432_ILLEGAL_INPUT_MODE		-1301
#define ERR1432_ILLEGAL_ANTI_ALIAS_MODE		-1302
#define ERR1432_ILLEGAL_INPUT_SOURCE		-1303
#define ERR1432_ILLEGAL_INPUT_GROUNDING		-1304
#define ERR1432_ILLEGAL_COUPLING		-1305
#define ERR1432_ILLEGAL_RANGE_DOWN		-1306
#define ERR1432_ILLEGAL_RANGE_UP		-1307
#define ERR1432_RANGE_OUT_OF_LIMITS		-1308
#define ERR1432_OFFSET_OUT_OF_LIMITS		-1309
#define ERR1432_ILLEGAL_ACTIVE_CHANNEL		-1310

/* data, getdata */
#define ERR1432_ILLEGAL_APPEND_STATUS_STATE	-1311
#define ERR1432_ILLEGAL_BLOCKSIZE		-1312
#define ERR1432_ILLEGAL_DATA_SIZE		-1313
#define ERR1432_ILLEGAL_DATA_MODE 		-1314
#define ERR1432_ILLEGAL_DATA_PORT		-1315
#define ERR1432_ILLEGAL_CHANNEL_ORDER		-1316
#define ERR1432_ILLEGAL_LBUS_MODE		-1317
#define ERR1432_ILLEGAL_LBUS_STATE		-1318
#define	ERR1432_ILLEGAL_OVERLAP			-1319

/* filter */
#define ERR1432_ILLEGAL_FILTER_PASS_MODE	-1320
#define ERR1432_ILLEGAL_ANTI_ALIAS_DIG_MODE	-1321
#define ERR1432_ILLEGAL_FILTER_BANDWIDTH	-1322
#define ERR1432_ILLEGAL_SETTLING_TIME		-1323
#define ERR1432_ILLEGAL_ZOOM_STATE		-1324
#define ERR1432_ILLEGAL_CENTER_FREQ		-1325
#define ERR1432_ILLEGAL_RAMP_STATE		-1326
#define	ERR1432_ILLEGAL_DECIMATION_OVERSAMPLE	-1327
#define	ERR1432_ILLEGAL_SPAN			-1328
#define	ERR1432_FIFO_OVERRUN			-1329

/* timing */
#define ERR1432_ILLEGAL_CLOCK_SOURCE		-1330
#define ERR1432_ILLEGAL_MULTI_SYNC_MODE		-1331
#define ERR1432_ILLEGAL_TTLTRG_LINE		-1332
#define ERR1432_ILLEGAL_CLOCK_MASTER		-1333
#define	ERR1432_NO_PLL_LOCK			-1334
#define ERR1432_ILLEGAL_GROUP_MEAS_STATE	-1335
#define	ERR1432_ILLEGAL_DECIMATION_UNDERSAMP	-1336
#define	ERR1432_ILLEGAL_CLOCK_FREQ		-1337
#define	ERR1432_ILLEGAL_CLOCK_OVERSAMPLE	-1338

/* trigger */
#define	ERR1432_ILLEGAL_TRIGGERS_PER_ARM	-1339
#define ERR1432_PRETRIGGER_GREATER_FIFO		-1340
#define ERR1432_ILLEGAL_POST_TRIGGER_DELAY	-1341
#define ERR1432_ILLEGAL_TRIGGER_LEVEL		-1342
#define ERR1432_WHICH_TRIGGER_LEVEL		-1343
#define ERR1432_ILLEGAL_TRIGGER_SLOPE		-1344
#define ERR1432_ILLEGAL_TRIGGER_MODE		-1345
#define ERR1432_ILLEGAL_TRIGGER_CHANNEL		-1346
#define ERR1432_ILLEGAL_ARM_STATE		-1347
#define ERR1432_ILLEGAL_TRIGGER_STATE		-1348
#define	ERR1432_ILLEGAL_TRIGGER_EXT		-1349

/* group, module, channel */
#define ERR1432_NO_GROUP			-1350
#define ERR1432_NO_ID				-1351
#define ERR1432_ILLEGAL_MODULE_COUNT		-1352
#define ERR1432_NO_MOD_AT_LA			-1353
#define ERR1432_INVALID_MODULE_OPTION		-1354
#define ERR1432_NO_CHANNEL			-1355
#define ERR1432_GROUP_NOT_CONTIGUOUS		-1356
#define ERR1432_TOO_MANY_MODULES		-1357
#define ERR1432_EXPECT_GROUP			-1358
#define ERR1432_EXPECT_CHANNEL			-1359

/* io, machine, interrupts */
#define ERR1432_STATUS_READ_TIMEOUT		-1360
#define ERR1432_BUS_ERROR			-1361
#define ERR1432_ILLEGAL_REGISTER_OFFSET		-1362
#define ERR1432_ILLEGAL_INTR_MASK 		-1363
#define ERR1432_ILLEGAL_INTR_PRIORITY		-1364
#define ERR1432_SYSTEM_TIME			-1365
#define ERR1432_UNABLE_TO_OPEN_SICL		-1366
#define ERR1432_UNABLE_TO_MAP_MEMORY		-1367
#define	ERR1432_ERROR_QUEUE_CORRUPT		-1368
#define	ERR1432_IONSRQ				-1369

/* miscellaneous */
#define ERR1432_PARAMETER_UNEQUAL		-1370
#define ERR1432_MALLOC				-1371
#define ERR1432_REALLOC				-1372
#define ERR1432_SIGVECTOR			-1373
#define ERR1432_MEAS_STATE_NOT_RESPONDING	-1374
#define ERR1432_AUTO_ZERO_TIMEOUT		-1375
#define ERR1432_LIST_ERROR			-1376
#define ERR1432_AUTO_ZERO_FAILURE		-1377
/* defunct ERR1432_ILLEGAL_AC_SETTLING		-1378 */
#define ERR1432_ILLEGAL_MODE           		-1379

/* calibration and flash rom  */
#define ERR1432_BAD_CAL_BLOCK			-1380
#define ERR1432_BAD_FLASH			-1381
#define ERR1432_VPP_ERROR			-1382
#define ERR1432_ROM_COMMAND			-1383
#define ERR1432_ROM_BYTE_PROGRAM		-1384
#define ERR1432_ROM_BLOCK_ERASE			-1385
#define	ERR1432_NO_FWREV			-1386

#define ERR1432_SELFTEST_FAILURE		-1389

/* More misc */
#define	ERR1432_DATA_MISALIGNED			-1390
#define	ERR1432_ILLEGAL_FIFO_SIZE		-1391
#define	ERR1432_HARDWARE_INCAPABLE		-1392
#define	ERR1432_FIRMWARE_ERROR			-1393

#define	ERR1432_ILLEGAL_AUTO_ZERO		-1395
#define	ERR1432_IO				-1396
#define ERR1432_FILE				-1397
#define	ERR1432_SYNC_TIMEOUT			-1398
#define	ERR1432_I2C				-1399

/* Source */
#define	ERR1432_ILLEGAL_AMP_SCALE		-1400
#define	ERR1432_ILLEGAL_FILTER_FREQ		-1401
#define	ERR1432_ILLEGAL_RAMP_RATE		-1402
#define	ERR1432_ILLEGAL_SINE_FREQ		-1403
#define	ERR1432_ILLEGAL_SINE_PHASE		-1404
#define	ERR1432_ILLEGAL_SOURCE_COLA		-1405
#define	ERR1432_ILLEGAL_SOURCE_SUM		-1406
#define	ERR1432_ILLEGAL_SOURCE_MODE		-1407
#define	ERR1432_ILLEGAL_DUTY_CYCLE		-1408
#define	ERR1432_ACK_TIMEOUT			-1409

/* Tach */
#define	ERR1432_ILLEGAL_TACH_DECIMATE		-1410
#define	ERR1432_ILLEGAL_TACH_HOLDOFF		-1411
#define	ERR1432_ILLEGAL_TACH_MAX_TIME		-1412
#define	ERR1432_ILLEGAL_TACH_INPUT		-1413
#define	ERR1432_ILLEGAL_TACH_SLOPE		-1414
#define	ERR1432_ILLEGAL_TACH_LEVEL		-1415
#define	ERR1432_ILLEGAL_TACH_HYST		-1416

#define	ERR1432_SICL_ERROR			-1417
#define	ERR1432_DMA_TIMEOUT			-1418
#define	ERR1432_DMA_ERROR			-1419

/* Configuration */
#define	ERR1432_CHAN_COUNT_MISMATCH		-1420
#define	ERR1432_SCA_NOT_CONTIG			-1421
#define	ERR1432_SELFTEST_FAILURE_SOURCE		-1422
#define	ERR1432_SOURCE_ERROR			-1423
#define	ERR1432_SOURCE_OVERLOAD			-1424
#define	ERR1432_SOURCE_SHUTDOWN			-1425
#define	ERR1432_ILLEGAL_CAL_DAC			-1426
#define	ERR1432_ILLEGAL_CALIN			-1427
#define	ERR1432_ILLEGAL_SUMBUS			-1428
#define	ERR1432_ILLEGAL_SOURCE_OUTPUT		-1429

/* Dervish specific */
#define ERR1432_ILLEGAL_ARM_TRIG_COMBO		-1430
#define ERR1432_ILLEGAL_PRE_ARM_MODE		-1431
#define ERR1432_ILLEGAL_ARM_MODE		-1432
#define ERR1432_ILLEGAL_WINDOW			-1433
#define ERR1432_ILLEGAL_NUMBER_ORDERS		-1434
#define ERR1432_ILLEGAL_PULSE_PER_REV		-1435
#define ERR1432_ILLEGAL_DELTA_ORDER  		-1436
#define ERR1432_ILLEGAL_TEST_TIME    		-1437
#define ERR1432_ILLEGAL_ARM_TIME_INTERVAL	-1438
#define ERR1432_ILLEGAL_ORDER_BLOCKSIZE		-1439
#define ERR1432_ILLEGAL_TRIGGER_RPM		-1440
#define ERR1432_ILLEGAL_CHANNEL_ADDRESS		-1441
#define ERR1432_ILLEGAL_DELTA_MAX_ORDER		-1442
#define ERR1432_ILLEGAL_ORDER_BINS		-1443
#define ERR1432_PARAM_BLOCK_INIT		-1444
#define ERR1432_ILLEGAL_TRIGGER_SOURCE		-1445
#define ERR1432_ILLEGAL_RPM_INTERVAL		-1446
#define ERR1432_ILLEGAL_RPM_LOW     		-1447
#define ERR1432_ILLEGAL_RPM_HIGH    		-1448
#define ERR1432_RPM_LOW_GREATER_HIGH		-1449
#define ERR1432_RPM_TOO_LOW_FOR_SPAN		-1450
#define ERR1432_RPM_TOO_HIGH_FOR_SPAN		-1451
#define ERR1432_ILLEGAL_TRIG_SOURCE_MODE	-1452
#define ERR1432_RPM_HIGH_NOT_MULT_INTERVAL	-1453
#define ERR1432_MALLOC_BLOCK_DATA		-1454
#define ERR1432_ILLEGAL_CP_BLOCKSIZ 		-1455
#define ERR1432_ILLEGAL_SKIP_N_TACHS		-1456
#define ERR1432_ILLEGAL_NUM_DATA_CHANNELS	-1457
#define ERR1432_ILLEGAL_DATA_MASK		-1458
#define ERR1432_NO_ARM_CHANNEL			-1459
#define ERR1432_ILLEGAL_AUTO_TIME		-1460
#define ERR1432_ILLEGAL_MAX_ORDER		-1461
#define ERR1432_ILLEGAL_COMP_POWER_START	-1462
#define ERR1432_ILLEGAL_COMP_POWER_BLOCKSIZE  	-1463
#define ERR1432_ILLEGAL_PPR_SKIP_TACH	  	-1464
#define ERR1432_ILLEGAL_SUB_CHANNEL	  	-1465
#define ERR1432_ILLEGAL_CHAN_ORDER	  	-1466
#define ERR1432_NOT_TACH_CHANNEL		-1467
#define ERR1432_ILLEGAL_MASTER_SLAVE	 	-1468
#define ERR1432_ILLEGAL_FALSE_TACH_REJ		-1469
#define ERR1432_ILLEGAL_TRIGGER_ACCURACY	-1470
#define ERR1432_ILLEGAL_EXT_TRIGGER_LEVEL	-1471
#define ERR1432_ILLEGAL_EXT_TRIGGER_CHAN	-1472
#define ERR1432_ILLEGAL_EXT_TRIGGER_SLOPE	-1473
#define ERR1432_ILLEGAL_EXT_TRIGGER_HYST	-1474
#define ERR1432_TACH_HOLDOFF_RPM_HIGH_WRONG	-1475
#define ERR1432_ILLEGAL_RPM_SMOOTHING		-1476
#define ERR1432_ILLEGAL_OT_BANDWIDTH		-1477
#define ERR1432_ILLEGAL_NUM_TACH_CHAN		-1478
#define ERR1432_ILLEGAL_DEBUG_FLAG		-1479
#define ERR1432_ILLEGAL_TRIGGER_POSITION	-1480
#define ERR1432_ILLEGAL_TRIGGER_MASTER		-1481
#define ERR1432_ILLEGAL_SAMPLE_MODE		-1482
#define ERR1432_RPM_STEP_LESS_INTERVAL		-1483
#define ERR1432_ILLEGAL_EXT_TRIGGER_NUM		-1484
#define ERR1432_TRIG_MASTER_GREATER_NUM_CHAN	-1485
#define ERR1432_ILLEGAL_RPM_MAX_STEP		-1486
#define ERR1432_ILLEGAL_AVG_MODE		-1487
#define ERR1432_ILLEGAL_AVG_NUMBER		-1488
#define ERR1432_NO_TACH_BOARD			-1489
#define ERR1432_ILLEGAL_TTL_TRIG_PAIR		-1490
#define ERR1432_ILLEGAL_USE_LBUS		-1491
#define ERR1432_ILLEGAL_CHANNEL_COUNT		-1492
#define ERR1432_ILLEGAL_EXT_TRIGGER_CHANNEL	-1493
#define ERR1432_ONLY_TWO_TACH_CHAN		-1494
#define ERR1432_NO_INPUT_SCA			-1495
#define ERR1432_ILLEGAL_RPM_HIGH_SKIP_TACH  	-1496
#define ERR1432_MALLOC_WINDOW_BUF		-1497
#define ERR1432_ILLEGAL_OT_INPUT_SCA		-1498
#define ERR1432_NEED_DRAM			-1499
#define ERR1432_ILLEGAL_ARM_CHANNEL		-1500
#define ERR1432_CURRENT_RPM_CHANNEL		-1501
#define ERR1432_ILLEGAL_MEAS_TIME_LENGTH	-1502
#define ERR1432_ILLEGAL_PRE_ARM_RPM		-1503
#define ERR1432_ILLEGAL_CALC_DATA		-1504

#define ERR1432_ORDER_MULTIPASS_OFF		-1506
#define ERR1432_ORDER_OVERSAMPLE_OFF		-1507
#define ERR1432_LBUS_TEST_TIMEOUT		-1508
#define ERR1432_LBUS_TEST_BAD_DATA		-1509
#define ERR1432_ILLEGAL_LBUS_TEST_MODE		-1510
#define ERR1432_OT_LOST_POINT			-1511
#define ERR1432_OT_LOST_FALLING_BEHIND		-1512
#define ERR1432_OT_FIFO_OVERFLOW		-1513
#define ERR1432_OT_UNKNOWN_ERROR		-1514


#define	ERR1432_BAD_INTERNAL_COMMAND		-1515
#define ERR1432_CALIBRATION_FAILURE		-1516
#define ERR1432_CAL_DISALLOWED			-1517
#define ERR1432_SRC0_XFRDATA_TOO_LONG		-1518
#define ERR1432_SRC0_XFRBUF_NRDY		-1519
#define ERR1432_ILLEGAL_SRC_BLKSIZE		-1520
#define ERR1432_ILLEGAL_SRC_SPAN		-1521
#define ERR1432_ILLEGAL_SRC_CENTERFREQ		-1522
#define ERR1432_FLASH_INVALID			-1523
#define ERR1432_ILLEGAL_PRE_ARM_CHANNEL		-1524
#define ERR1432_ILLEGAL_SRCBUFFER_MODE		-1525
#define	ERR1432_SOURCE_OVERREAD			-1526
#define	ERR1432_TACH_BUFFER_OVERFLOW		-1527
#define	ERR1432_TACH_XFER_TIMEOUT		-1528
#define	ERR1432_REJECT_SLAVE_TRIGGER		-1529

#define ERR1432_COUPLING_FREQ_OUT_OF_LIMITS	-1530
#define ERR1432_ILLEGAL_WEIGHTING		-1531
#define ERR1432_INPUT_OFFSET_OUT_OF_LIMITS	-1532
#define ERR1432_AUTOZERO_OFFSET_OUT_OF_LIMITS	-1533

#define ERR1432_DUPLICATE_TACH_TIME		-1534
#define	ERR1432_ILLEGAL_ENABLE			-1535
#define	ERR1432_DATA_HANDSHAKE_TIMEOUT		-1536

#define ERR1432_NOT_FUNCTIONAL			-1537
#define ERR1432_SCA_HOSTPORT_FAIL		-1538
#define ERR1432_SCA_BOOT_FAIL			-1539

/* Selftest failures */
#define	ERR1432_SELFTEST_DMA_TIMEOUT		-1540
#define	ERR1432_SELFTEST_DRAM_SIZE		-1541
#define	ERR1432_SELFTEST_DRAM			-1542
#define	ERR1432_SELFTEST_DRAM_FULL		-1543
#define	ERR1432_SELFTEST_YSRAM			-1544
#define	ERR1432_SELFTEST_XIRAM			-1545
#define	ERR1432_SELFTEST_XSRAM			-1546
#define	ERR1432_SELFTEST_XSRAM2			-1547
#define	ERR1432_SELFTEST_XYSRAM			-1548
#define	ERR1432_SELFTEST_XYSRAM2		-1549
#define	ERR1432_SELFTEST_TACH_ROLLOVER		-1550
#define	ERR1432_SELFTEST_TACH_FULL		-1551
#define	ERR1432_SELFTEST_TACH_EMPTY		-1552
#define	ERR1432_SELFTEST_TACH_COUNT		-1553

#define	ERR1432_ILLEGAL_ENABLE_COMBINATION	-1554
#define	ERR1432_ILLEGAL_XFER_SIZE		-1555

#define ERR1432_ILLEGAL_AVG_UPDATE		-1556
#define ERR1432_ILLEGAL_AVG_WEIGHT		-1557

#define	ERR1432_BAD_E1433_SUBSTRATE		-1558
#define	ERR1432_E1433_RESISTOR_FAILURE		-1559
#define	ERR1432_ILLEGAL_BLOCK_ORDER_COMBO	-1560
#define	ERR1432_ILLEGAL_ORDER_TRIGGER_DELAY	-1561
#define	ERR1432_NO_AVG_WITH_RPM_TRIG		-1562

#define	ERR1432_ILLEGAL_RANGE_CHARGE		-1563
#define	ERR1432_ILLEGAL_RANGE_MIKE		-1564
#define ERR1432_ILLEGAL_ORDER_CHANNEL_COMBO     -1565

#define ERR1432_SCA_BUS_ERROR			-1566
#define ERR1432_SCA_FIRMWARE_ERROR		-1567
#define ERR1432_SCA_ADC_DATA_OVERRUN		-1568
#define ERR1432_SCA_DSP_DATA_OVERRUN		-1569

#define ERR1432_RMS_SPAN_MISMATCH               -1570
#define ERR1432_ILLEGAL_RMS_SPAN                -1571
#define ERR1432_ILLEGAL_RMS_DECAY_TIME          -1572
#define ERR1432_RMS_DECAY_TIME_MISMATCH         -1573
#define ERR1432_ILLEGAL_PEAK_HOLD_TIME          -1574
#define ERR1432_BUFFER_TOO_SMALL                -1575
#define ERR1432_PRIOR_SPECTRUM_REQUESTED        -1576
#define ERR1432_NO_SPECTRUM_READY               -1577
#define ERR1432_SRC_ROMFILE_CHECKCODE		-1578
#define ERR1432_SRC_ROMFILE_SIZE		-1579
#define ERR1432_SRC_ROMFILE_TRAILER		-1580
#define ERR1432_ILLEGAL_PEAK_MODE		-1581
#define ERR1432_ILLEGAL_RMS_MODE		-1582
#define ERR1432_ILLEGAL_CURRENT_VALUE		-1583
#define ERR1432_ILLEGAL_RMS_AVG_TIME		-1584
#define ERR1432_Y_MEMORY_ALLOCATION		-1585
#define ERR1432_WEIGHTING_VS_CLOCK_F		-1586
#define ERR1432_DECIMATION_VS_CLOCK_F		-1587
#define ERR1432_PEAK_RMS_VS_CLOCK_F		-1588
#define	ERR1432_AUTO_RANGE_FAILURE		-1589
#define ERR1432_ILLEGAL_PEAK_DECAY_TIME		-1590
#define ERR1432_ILLEGAL_AUTO_RANGE_MODE		-1591
/* diagnostics failures */
#define ERR1432_DIAG_ERR_UNDIAGNOSED		-1592
#define ERR1432_DIAG_ERR_SUBST			-1593
#define ERR1432_DIAG_ERR_DRAM			-1594
#define ERR1432_DIAG_ERR_TACH			-1595
#define ERR1432_DIAG_ERR_SOURCE_FIT		-1596
#define ERR1432_DIAG_ERR_SOURCE_SCA0		-1597
#define ERR1432_DIAG_ERR_SOURCE_SCA1		-1598
#define ERR1432_DIAG_ERR_INPUT_SCA0		-1599
#define ERR1432_DIAG_ERR_INPUT_SCA1		-1600
#define ERR1432_DIAG_ERR_INPUT_SCA2		-1601
#define ERR1432_DIAG_ERR_INPUT_SCA3		-1602

#define	ERR1432_AUTO_RANGE_VS_CLOCK_F		-1603
#define	ERR1432_SRC_REALTIME_RESTRICTION	-1604

#define ERR1432_ILLEGAL_OCTAVE_MODE		-1605
#define ERR1432_ILLEGAL_OCTAVE_AVG_MODE		-1606
#define ERR1432_ILLEGAL_OCTAVE_HOLD_MODE	-1607
#define ERR1432_ILLEGAL_OCTAVE_START_FREQ	-1608
#define ERR1432_ILLEGAL_OCTAVE_STOP_FREQ	-1609
#define ERR1432_ILLEGAL_OCTAVE_INT_TIME		-1610
#define ERR1432_ILLEGAL_OCTAVE_TIME_CONST	-1611
#define ERR1432_ILLEGAL_OCTAVE_TIME_STEP	-1612
#define ERR1432_ILLEGAL_OCTAVE_CLOCK_FREQ	-1613
#define ERR1432_ILLEGAL_OCTAVE_CTL		-1614
#define ERR1432_ILLEGAL_USER_DECIMATION		-1615
#define ERR1432_ILLEGAL_USER_FRAMES_PER_BLOCK	-1616
#define ERR1432_ILLEGAL_GET_CURRENT_DATA_CHAN	-1617
#define ERR1432_ILLEGAL_GET_CURRENT_DATA_TYPE	-1618
#define ERR1432_ILLEGAL_USER_BLOCKSIZE		-1619

#define	ERR1432_AF_OVERRUN			-1620
#define	ERR1432_OPTION_NOT_INSTALLED		-1621
#define	ERR1432_INVALID_OPTION_STRING		-1622
#define ERR1432_ILLEGAL_TACH_IRQ_NUMBER		-1623
#define ERR1432_DATA_UNAVAILABLE		-1624
#define ERR1432_ILLEGAL_GET_CURRENT_DATA_SIZE	-1625
#define	ERR1432_DATA_SIZE_VS_CLOCK_FREQ		-1626
#define	ERR1432_OCTAVE_VS_CLOCK_FREQ		-1627
#define	ERR1432_OCTAVE_VS_MODULE_TYPE		-1628
#define	ERR1432_ILLEGAL_SRCBUFFER_SIZE		-1629
#define ERR1432_ILLEGAL_OCTAVE_FREQS		-1630
#define ERR1432_ILLEGAL_OCTAVE_MEAS		-1631
#define	ERR1432_ILLEGAL_SRCBUFFER_INIT		-1632
#define ERR1432_ILLEGAL_OCTAVE_DECIMATION	-1633
#define ERR1432_INTERNAL_LIBRARY_ERROR		-1634
#define	ERR1432_ILLEGAL_SRC_DATA_MODE		-1635
#define	ERR1432_DRAM_CONFLICT			-1636
#define ERR1432_ILLEGAL_ORDER_CHANNEL_COMBO33   -1637
#define ERR1432_SEMA_BIN_MISMATCH		-1638
#define ERR1432_SERIAL_NUM_ZAP_NOT_ALLOWED	-1639
#define	ERR1432_REQUIRE_VIBRATO_B		-1640
#define	ERR1432_ILLEGAL_ARM_CHAN_NUM		-1641
#define	ERR1432_REQUEST_MEAS_RUNNING		-1642
#define	ERR1432_REQUEST_SPAN_CHANGE		-1643
#define	ERR1432_REQUEST_ZOOM			-1644
#define ERR1432_PEAK_SPAN_MISMATCH              -1645
#define ERR1432_ILLEGAL_PEAK_SPAN               -1646
#define ERR1432_HPF_SPAN_MISMATCH               -1647
#define ERR1432_ILLEGAL_HPF_SPAN                -1648
#define ERR1432_PEAK_HOLD_TIME_MISMATCH         -1649
#define ERR1432_BAD_SCA_DOWNLOADABLE		-1650
#define	ERR1432_REQUIRE_ONE_MOD			-1651
#define	ERR1432_LOCK_FAILED			-1652
#define ERR1432_SCA_EEPROM_INVALID		-1653

/* Keep at bottom of list to match error.c and manually
   change the LAST_ERROR_NUMBER when more messages
   are added.  Sorry about that. */
#define ERR1432_LAST_ERROR_NUMBER               -1653

#endif /* _E1432_ERROR_H */
